module RPG
  class System
    def initialize
      @magic_number = 0
      @party_members = [1]
      @elements = [nil, ""]
      @switches = [nil, ""]
      @variables = [nil, ""]
      @windowskin_name = ""
      @title_name = ""
      @gameover_name = ""
      @battle_transition = ""
      @title_bgm = RPG::AudioFile.new
      @battle_bgm = RPG::AudioFile.new
      @battle_end_me = RPG::AudioFile.new
      @gameover_me = RPG::AudioFile.new
      @cursor_se = RPG::AudioFile.new("", 80)
      @decision_se = RPG::AudioFile.new("", 80)
      @cancel_se = RPG::AudioFile.new("", 80)
      @buzzer_se = RPG::AudioFile.new("", 80)
      @equip_se = RPG::AudioFile.new("", 80)
      @shop_se = RPG::AudioFile.new("", 80)
      @save_se = RPG::AudioFile.new("", 80)
      @load_se = RPG::AudioFile.new("", 80)
      @battle_start_se = RPG::AudioFile.new("", 80)
      @escape_se = RPG::AudioFile.new("", 80)
      @actor_collapse_se = RPG::AudioFile.new("", 80)
      @enemy_collapse_se = RPG::AudioFile.new("", 80)
      @words = RPG::System::Words.new
      @test_battlers = []
      @test_troop_id = 1
      @start_map_id = 1
      @start_x = 0
      @start_y = 0
      @battleback_name = ""
      @battler_name = ""
      @battler_hue = 0
      @edit_map_id = 1
    end
    attr_accessor :magic_number
    attr_accessor :party_members
    attr_accessor :elements
    attr_accessor :switches
    attr_accessor :variables
    attr_accessor :windowskin_name
    attr_accessor :title_name
    attr_accessor :gameover_name
    attr_accessor :battle_transition
    attr_accessor :title_bgm
    attr_accessor :battle_bgm
    attr_accessor :battle_end_me
    attr_accessor :gameover_me
    attr_accessor :cursor_se
    attr_accessor :decision_se
    attr_accessor :cancel_se
    attr_accessor :buzzer_se
    attr_accessor :equip_se
    attr_accessor :shop_se
    attr_accessor :save_se
    attr_accessor :load_se
    attr_accessor :battle_start_se
    attr_accessor :escape_se
    attr_accessor :actor_collapse_se
    attr_accessor :enemy_collapse_se
    attr_accessor :words
    attr_accessor :test_battlers
    attr_accessor :test_troop_id
    attr_accessor :start_map_id
    attr_accessor :start_x
    attr_accessor :start_y
    attr_accessor :battleback_name
    attr_accessor :battler_name
    attr_accessor :battler_hue
    attr_accessor :edit_map_id


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_System)
      my.words = my.words.to_dmk
      return my
    end


    def comparer(other)
      
      list_self = [
        @magic_number,
        @party_members,
        @elements,
        @switches,
        @variables,
        @windowskin_name,
        @title_name,
        @gameover_name,
        @battle_transition,
        @test_battlers,
        @test_troop_id,
        @start_map_id,
        @start_x,
        @start_y,
        @battleback_name,
        @battler_name,
        @battler_hue,
        @edit_map_id
      ]

      list_other = [
        other.magic_number,
        other.party_members,
        other.elements,
        other.switches,
        other.variables,
        other.windowskin_name,
        other.title_name,
        other.gameover_name,
        other.battle_transition,
        other.test_battlers,
        other.test_troop_id,
        other.start_map_id,
        other.start_x,
        other.start_y,
        other.battleback_name,
        other.battler_name,
        other.battler_hue,
        other.edit_map_id
      ]


      if list_self != list_other
        raise(DMKW_DMK_Diff.new("system.parameters"))
      end

      list_self_comparer = [
        @title_bgm,
        @battle_bgm,
        @battle_end_me,
        @gameover_me,
        @cursor_se,
        @decision_se,
        @cancel_se,
        @buzzer_se,
        @equip_se,
        @shop_se,
        @save_se,
        @load_se,
        @battle_start_se,
        @escape_se,
        @actor_collapse_se,
        @enemy_collapse_se,
        @words
      ]

      list_other_comparer = [
        other.title_bgm,
        other.battle_bgm,
        other.battle_end_me,
        other.gameover_me,
        other.cursor_se,
        other.decision_se,
        other.cancel_se,
        other.buzzer_se,
        other.equip_se,
        other.shop_se,
        other.save_se,
        other.load_se,
        other.battle_start_se,
        other.escape_se,
        other.actor_collapse_se,
        other.enemy_collapse_se,
        other.words
      ]

      for i in 0...list_self_comparer.size
        raise(DMKW_DMK_Diff.new("System.comparer")) if list_self_comparer[i].comparer(list_other_comparer[i]) == false
      end

      return true
    end


  end
end
